/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.spawning.SpawnTypeBlockBreak;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnTypeTree
extends SpawnTypeBlockBreak {
    public SpawnTypeTree(String typeName) {
        super(typeName);
    }

    @Override
    public boolean validBlockBreak(Block block, World world, BlockPos pos, Entity entity) {
        return this.isTreeLeavesBlock(block, world, pos);
    }

    @Override
    public boolean validBlockHarvest(Block block, World world, BlockPos pos, Entity entity) {
        if (!super.validBlockHarvest(block, world, pos, entity)) {
            return false;
        }
        return this.isTreeLogBlock(block, world, pos) || this.isTreeLeavesBlock(block, world, pos);
    }

    public boolean isTreeLogBlock(Block block, World world, BlockPos pos) {
        if (block instanceof BlockLog || ObjectLists.isInOreDictionary("logWood", block)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY <= Math.min(world.func_72800_K(), y + 32); ++searchY) {
                        Block searchBlock = world.func_180495_p(new BlockPos(searchX, searchY, searchZ)).func_177230_c();
                        if (searchBlock == block || searchBlock == null) continue;
                        if (ObjectLists.isInOreDictionary("treeLeaves", searchBlock)) {
                            return true;
                        }
                        if (!world.func_175623_d(new BlockPos(x, searchY, z))) continue block1;
                    }
                }
            }
        }
        return false;
    }

    public boolean isTreeLeavesBlock(Block block, World world, BlockPos pos) {
        if (block instanceof BlockLeaves || ObjectLists.isInOreDictionary("treeLeaves", block)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY >= Math.max(0, y - 32); --searchY) {
                        Block searchBlock = world.func_180495_p(new BlockPos(searchX, searchY, searchZ)).func_177230_c();
                        if (searchBlock == block || searchBlock == null) continue;
                        if (ObjectLists.isInOreDictionary("logWood", searchBlock)) {
                            return true;
                        }
                        if (!world.func_175623_d(new BlockPos(x, searchY, z))) continue block1;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean canSpawn(long tick, World world, BlockPos pos, int rank) {
        double roll = world.field_73012_v.nextDouble();
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt != null && "rootriot".equalsIgnoreCase(worldExt.getWorldEventType())) {
            roll /= 4.0;
        }
        return !(roll >= this.chance);
    }

    @Override
    public List<BlockPos> orderCoords(List<BlockPos> coords, BlockPos pos) {
        return this.orderCoordsCloseToFar(coords, pos);
    }
}

